﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//ColourEntry represents a colour entry in the Colours.xml
public class ColourEntry
{
    public string Key { get; private set; }
    public List<string> Tags { get; private set; }  //Any tags associated with the colour, can be used for non-grouped selections
    public Color Colour { get; private set; }

    public ColourEntry(string key, Color colour)
    {
        Key = key;
        Tags = new List<string>();
        Colour = colour;
    }

    public ColourEntry(string key, List<string> tags, Color colour)
    {
        Key = key;
        Tags = tags;
        Colour = colour;
    }
}